/* (c) 1997 by H.Robbers Amsterdam
 *  Manipulate with auto folder name's to ease switching between
 *  Atari monitor & NOVA monitor.
 *   Either under MagiC || MiNT || TOS.
 */

#include <stdio.h>
#include <string.h>
#include <tos.h>

/* to see what is current */
char mm_a[]="C:\\AUTO\\MAGIC_MO.NO\\MAGIC_MO.NO";
char mc_a[]="C:\\AUTO\\MAGIC_CO.LOR\\MAGIC_CO.LOR";
char tm_a[]="C:\\AUTO\\TOS_MONO\\TOS_MONO";
char tc_a[]="C:\\AUTO\\TOS_COLO.R\\TOS_COLO.R";
char im_a[]="C:\\AUTO\\MINT_MON.O\\MINT_MON.O";
char ic_a[]="C:\\AUTO\\MINT_COL.OR\\MINT_COL.OR";

/* to change to */
char mm[]="C:\\AUTO.MM";
char mc[]="C:\\AUTO.MC";
char tm[]="C:\\AUTO.TM";
char tc[]="C:\\AUTO.TC";
char im[]="C:\\AUTO.IM";
char ic[]="C:\\AUTO.IC";

char nm[]="C:\\NVDISYS.TTM";
char nc[]="C:\\NVDISYS.NOV";

int MagX,MiNT;
long sstack;

typedef struct
{
	long id,val;
} COOKIE;

int get_cookie(long cookie, long *value)
{
	COOKIE *jar;

	(long)sstack = Super(0L);
	jar = *(COOKIE **)0x5a0L; /* JAR (long *)0x5a0L */
	Super(sstack);

	if (!jar)
		return 0;

	while(jar->id)
	{
		if (jar->id == cookie)
		{
			if (value)
				*value = jar->val;
			return 1;
		}
		jar++;
	}
	return 0;
}

long end_ren(long ok, char *now, char *to)
{
	if (ok)
		if (!(MagX|MiNT))
			Bconin(2);
		else ;
	else
		printf("%s --> %s\n",now,to);
	return ok;
}

long change_auto(char *now, char *to)
{
	long ok1,ok2;

	ok1 = Frename(0,"C:\\AUTO",now);	/* existing auto to what's in it */
	if (ok1 == 0)
		ok2 = Frename(0,to,"C:\\AUTO"); /* given auto.ext to auto */

	if (ok1)
		printf("rename from auto failed: %d\n",ok1);
	if (ok2)
		printf("rename to auto failed: %d\n",ok2);
	return end_ren(ok1|ok2,now,to);
}

long change_nvdi(char *now,char *to)
{
	long ok1,ok2;

	ok1 = Frename(0,"C:\\NVDISYS",now);
	if (ok1 == 0)
		ok2 = Frename(0,to,"C:\\NVDISYS");
	if (ok1)
		printf("rename from nvdisys failed: %d\n",ok1);
	if (ok2)
		printf("rename to nvdisys failed: %d\n",ok2);
	return end_ren(ok1|ok2,now,to);
}

long change(char *to,char *ton)	/* find out what is in current auto */
{
	long ok;
	
	ok = Fopen(mm_a,0);
	if (ok>0)
		return change_nvdi(nm,ton)|change_auto(mm,to);
	ok = Fopen(mc_a,0);
	if (ok>0)
		return change_nvdi(nc,ton)|change_auto(mc,to);
	ok = Fopen(tm_a,0);
	if (ok>0)
		return change_nvdi(nm,ton)|change_auto(tm,to);
	ok = Fopen(tc_a,0);
	if (ok>0)
		return change_nvdi(nc,ton)|change_auto(tc,to);
	ok = Fopen(im_a,0);
	if (ok>0)
		return change_nvdi(nm,ton)|change_auto(im,to);
	ok = Fopen(ic_a,0);
	if (ok>0)
		return change_nvdi(nc,ton)|change_auto(ic,to);

	printf("auto &| nvdi names messed up\n");
	if (!(MagX|MiNT))
		Bconin(2);
	return 1;
}

int main(int argc, char *argv[])
{
	long fl;
	MagX=get_cookie('MagX',0L);
	MiNT=get_cookie('MiNT',0L);

	if (argc > 1)
	{
		printf("name -=%s=-\n",argv[1]);
	
		if (strncmp(argv[1],"C:\\AUTO.",8) == 0)
		{
			char *s = argv[1];
			while (*s && *s != '.') s++;
			s++;
			/* The argv tells what we want to have.
			   that name must change to "auto".
			   But before that we must look what is in the current "auto"
			   && change that "auto" to what's mentioned within it.
			   This is determined in 'change()'
			*/
			if (*(s+2) == 0 || *(s+2) == '\\')
			{
				if (*s == 'T' && *(s+1) == 'C')	/* TOS color */
					return change(tc,nc);

				if (*s == 'T' && *(s+1) == 'M')	/* TOS mono  */
					return change(tm,nm);

				if (*s == 'M' && *(s+1) == 'C')	/* MagiC color */
					return change(mc,nc);

				if (*s == 'M' && *(s+1) == 'M')	/* MagiC mono  */
					return change(mm,nm);

				if (*s == 'I' && *(s+1) == 'C') /* MiNT color */
					return change(ic,nc);

				if (*s == 'I' && *(s+1) == 'M') /* MiNT mono */
					return change(im,nm);

			}
			printf("needs one of .TC, .TM, .MC, .MM, .IC || .IM\n");
			if (!(MagX|MiNT))
				Bconin(2);
			return 1;
		}

		printf("needs suitable C:\\AUTO.....\n");
		if (!(MagX|MiNT))
			Bconin(2);
		return 1;
	}
	else
	{
		printf("needs argument\n");
		if (!(MagX|MiNT))
			Bconin(2);
		return 1;
	}
}
